# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class ProbeLineFilter(DataObjectAlgorithm):
    r"""
    ProbeLineFilter - probe dataset along a line in parallel
    
    Superclass: DataObjectAlgorithm
    
    This filter probes the input data set along an source dataset
    composed of `Line` and/or `vtkpoly_line` cells. It outputs a
    `vtkpoly_data`, or a `vtkmulti_block_data_set` if asked. In the case of a
    multiblock, each block contains the probe result for a single cell of
    the source. In the case of a polydata output and multiple input
    lines, only the first line results are returned. Points are sorted
    along the line or the polyline. Cells are outputted in the same order
    they were defined in the input (i.e. cells 0 is block 0 of the
    output).
    
    The probing can have different sampling patterns. Three are
    available:
    * `SAMPLE_LINE_AT_CELL_BOUNDARIES`: The intersection between the
      input line and the input data set is computed. At each intersection
    point, 2 points are generated, slightly shifted inside each
      interfacing cell. Points are moved back to the intersection after
      probing. This sampling pattern should typically be used on input
      data sets holding cell data if one wants to output a step function
      profile.
    * `SAMPLE_LINE_AT_SEGMENT_CENTERS`: Center points each consecutive
      segment formed by the Probing points computed with
      `SAMPLE_LINE_AT_CELL_BOUNDARIES` are used for probing. This outputs
    one point per cell, in addition to the end points of a segment.
    * `SAMPLE_LINE_UNIFORMLY`: A uniformly sampled line is used for
      probing. In this instance, `line_resolution` is used to determine
      how many samples are being generated
    
    ote In every sampling pattern, the end points are included in the
    probing, even if they are outside the input data set.
    
    @attention In case of a distributed pipeline, the dataset used to
    determine the lines to probe from (ie the dataset on port 1) will
    always be the one from rank 0, and will be broadcasted to all other
    ranks.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkProbeLineFilter, obj, update, **traits)
    
    aggregate_as_poly_data = tvtk_base.true_bool_trait(desc=\
        r"""
        
        """
    )

    def _aggregate_as_poly_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAggregateAsPolyData,
                        self.aggregate_as_poly_data_)

    compute_tolerance = tvtk_base.true_bool_trait(desc=\
        r"""
        Set whether to use the Tolerance field or precompute the
        tolerance. When on, the tolerance will be computed and the field
        value is ignored. On by default.
        """
    )

    def _compute_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeTolerance,
                        self.compute_tolerance_)

    pass_cell_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        Shallow copy the input cell data arrays to the output. Off by
        default.
        """
    )

    def _pass_cell_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassCellArrays,
                        self.pass_cell_arrays_)

    pass_field_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        Set whether to pass the field-data arrays from the Input i.e. the
        input providing the geometry to the output. On by default.
        """
    )

    def _pass_field_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassFieldArrays,
                        self.pass_field_arrays_)

    pass_partial_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        When dealing with composite datasets, partial arrays are common
        i.e. data-arrays that are not available in all of the blocks. By
        default, this filter only passes those point and cell data-arrays
        that are available in all the blocks i.e. partial array are
        removed.  When pass_partial_arrays is turned on, this behavior is
        changed to take a union of all arrays present thus partial arrays
        are passed as well. However, for composite dataset input, this
        filter still produces a non-composite output. For all those
        locations in a block of where a particular data array is missing,
        this filter uses Math::Nan() for double and float arrays,
        while 0 for all other types of arrays i.e int, char etc.
        """
    )

    def _pass_partial_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassPartialArrays,
                        self.pass_partial_arrays_)

    pass_point_arrays = tvtk_base.false_bool_trait(desc=\
        r"""
        Shallow copy the input point data arrays to the output Off by
        default.
        """
    )

    def _pass_point_arrays_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPassPointArrays,
                        self.pass_point_arrays_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    line_resolution = traits.Int(1000, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _line_resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLineResolution,
                        self.line_resolution)

    sampling_pattern = traits.Trait(0, traits.Range(0, 2, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _sampling_pattern_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSamplingPattern,
                        self.sampling_pattern)

    tolerance = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the tolerance used to compute whether a point in the source
        is in a cell of the input.  This value is only used if
        compute_tolerance is off.
        """
    )

    def _tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTolerance,
                        self.tolerance)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_source_connection(self, *args):
        """
        set_source_connection(self, input:AlgorithmOutput) -> None
        C++: virtual void set_source_connection(AlgorithmOutput *input)
        Set the source for creating the lines to probe from. Only cells
        of type VTK_LINE or VTK_POLY_LINE will be processed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceConnection, *my_args)
        return ret

    _updateable_traits_ = \
    (('aggregate_as_poly_data', 'GetAggregateAsPolyData'),
    ('compute_tolerance', 'GetComputeTolerance'), ('pass_cell_arrays',
    'GetPassCellArrays'), ('pass_field_arrays', 'GetPassFieldArrays'),
    ('pass_partial_arrays', 'GetPassPartialArrays'), ('pass_point_arrays',
    'GetPassPointArrays'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('line_resolution', 'GetLineResolution'), ('sampling_pattern',
    'GetSamplingPattern'), ('tolerance', 'GetTolerance'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'aggregate_as_poly_data', 'compute_tolerance',
    'debug', 'global_warning_display', 'pass_cell_arrays',
    'pass_field_arrays', 'pass_partial_arrays', 'pass_point_arrays',
    'release_data_flag', 'line_resolution', 'object_name',
    'progress_text', 'sampling_pattern', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ProbeLineFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ProbeLineFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['aggregate_as_poly_data', 'compute_tolerance',
            'pass_cell_arrays', 'pass_field_arrays', 'pass_partial_arrays',
            'pass_point_arrays'], [], ['line_resolution', 'object_name',
            'sampling_pattern', 'tolerance']),
            title='Edit ProbeLineFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ProbeLineFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

