/*
 * Decompiled with CFR 0.152.
 */
package org.helios.jmx.dynamic.container;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.MBeanOperationInfo;
import org.helios.jmx.dynamic.container.MBeanContainer;

public class OperationContainer
extends MBeanContainer
implements Serializable {
    private static final long serialVersionUID = -4915660094118175218L;
    protected MBeanOperationInfo operInfo = null;
    protected Method targetMethod = null;
    protected boolean asynch = false;

    public OperationContainer(Object targetObject, MBeanOperationInfo operInfo, Method targetMethod, boolean async) {
        this.targetObject = targetObject;
        this.operInfo = operInfo;
        this.targetMethod = targetMethod;
        this.asynch = async;
    }

    public OperationContainer(Object targetObject, String description, Method targetMethod) {
        this(targetObject, new MBeanOperationInfo(description, targetMethod), targetMethod, false);
    }

    public Object invokeOperation(Object ... args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.targetMethod.invoke(this.targetObject, args);
    }

    public boolean isAsynch() {
        return this.asynch;
    }

    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }

    public MBeanOperationInfo getOperInfo() {
        return this.operInfo;
    }

    public void setOperInfo(MBeanOperationInfo operInfo) {
        this.operInfo = operInfo;
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetMethod(Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public static String hashOperationName(String actionName, String[] signature) {
        if (signature == null || signature.length < 1) {
            return "" + actionName.hashCode();
        }
        StringBuilder buff = new StringBuilder(actionName);
        for (String s : signature) {
            buff.append(s);
        }
        return "" + buff.toString().hashCode();
    }

    public static String hashOperationName(String actionName, Class[] signature) {
        if (signature == null || signature.length < 1) {
            return "" + actionName.hashCode();
        }
        String[] classes = new String[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            classes[i] = signature[i].getName();
        }
        return OperationContainer.hashOperationName(actionName, classes);
    }
}

