/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PCIPORTGROUP_H_
#define OPENDRIM_PCIPORTGROUP_H_

#include <Instance.h>

const static char* OpenDRIM_PCIPortGroup_classnames[] = {"OpenDRIM_PCIPortGroup"};
static string OpenDRIM_PCIPortGroup_NAMESPACE = _NAMESPACE;

class OpenDRIM_PCIPortGroup {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	string NameFormat;
	bool NameFormat_isNULL;
	
	string OtherNameFormat;
	bool OtherNameFormat_isNULL;
	
	unsigned char BusNumber;
	bool BusNumber_isNULL;
	
	OpenDRIM_PCIPortGroup() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstanceID_isNULL = true;
		Name_isNULL = true;
		NameFormat_isNULL = true;
		OtherNameFormat_isNULL = true;
		BusNumber_isNULL = true;
	}
	
	~OpenDRIM_PCIPortGroup() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getNameFormat(string& value) const {
		if (NameFormat_isNULL==true)
			return NOT_FOUND;
		value = NameFormat;
		return OK;
	}
	
	int setNameFormat(const string& newValue) {
		NameFormat = newValue;
		NameFormat_isNULL = false;
		return OK;
	}

	int getOtherNameFormat(string& value) const {
		if (OtherNameFormat_isNULL==true)
			return NOT_FOUND;
		value = OtherNameFormat;
		return OK;
	}
	
	int setOtherNameFormat(const string& newValue) {
		OtherNameFormat = newValue;
		OtherNameFormat_isNULL = false;
		return OK;
	}

	int getBusNumber(unsigned char& value) const {
		if (BusNumber_isNULL==true)
			return NOT_FOUND;
		value = BusNumber;
		return OK;
	}
	
	int setBusNumber(const unsigned char& newValue) {
		BusNumber = newValue;
		BusNumber_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_PCIPORTGROUP_H_*/
