/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
/*
 * @test
 * @bug 8000354
 * @summary Test
 * @compile -XDignore.symbol.file CustomProvider.java MyXmlPropertiesProvider.java
 * @run main/othervm -Dsun.util.spi.XmlPropertiesProvider=MyXmlPropertiesProvider CustomProvider
 */

import java.util.*;
import java.io.*;

/**
 * Sanity test to verify that the property sun.util.spi.XmlPropertiesProvider
 * can be used to specify a custom provider for loading/storing properties
 * in XML format.
 */
public class CustomProvider {

    public static void main(String[] args) throws IOException {
        String provider = System.getProperty("sun.util.spi.XmlPropertiesProvider");
        assertTrue(provider != null, "sun.util.spi.XmlPropertiesProvider not set");

        OutputStream out = new ByteArrayOutputStream();
        InputStream in = new ByteArrayInputStream(new byte[100]);

        Properties props;

        props = new Properties();
        props.loadFromXML(in);

        props = System.getProperties();
        props.storeToXML(out, "comment");
        props.storeToXML(out, "comment", "UTF-8");

        // check that the provider's load and store methods have been invoked

        assertTrue(MyXmlPropertiesProvider.createCount() == 1,
            "Provider should only be created once");
        assertTrue(MyXmlPropertiesProvider.loadCount() == 1,
            "load method expected to be called once");
        assertTrue(MyXmlPropertiesProvider.storeCount() == 2,
             "store method expected to be called twice");
    }

    static void assertTrue(boolean b, String msg) {
        if (!b) throw new RuntimeException(msg);
    }
}
