# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1312-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58360);
 script_cve_id("CVE-2007-1860");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1312-1 (libapache-mod-jk)";
 script_name(name);

 desc = "The remote host is missing an update to libapache-mod-jk
announced via advisory DSA 1312-1.

It was discovered that the Apache 1.3 connector for the Tomcat Java
servlet engine decoded request URLs multiple times, which can lead
to information disclosure.

For the oldstable distribution (sarge) this problem has been fixed in
version 1.2.5-2sarge1. An updated package for powerpc is not yet
available due to problems with the build host. It will be provided
later.

For the stable distribution (etch) this problem has been fixed in
version 1.2.18-3etch1.

For the unstable distribution (sid) this problem has been fixed in
version 1.2.23-1.

We recommend that you upgrade your libapache-mod-jk package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201312-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1312-1 (libapache-mod-jk)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libapache-mod-jk", ver:"1.2.5-2sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-jk-doc", ver:"1.2.18-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-jk", ver:"1.2.18-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-jk", ver:"1.2.18-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
