# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 730-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53559);
 script_bugtraq_id(12954);
 script_cve_id("CVE-2005-0953");
 script_version ("$");
 script_tag(name:"cvss_base", value:"3.7");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 730-1 (bzip2)";
 script_name(name);

 desc = "The remote host is missing an update to bzip2
announced via advisory DSA 730-1.

Imran Ghory discovered a race condition in bzip2, a high-quality
block-sorting file compressor and decompressor.  When decompressing a
file in a directory an attacker has access to, bunzip2 could be
tricked to set the file permissions to a different file the user has
permissions to.

For the stable distribution (woody) this problem has been fixed in
version 1.0.2-1.woody2

For the testing distribution (sarge) this problem has been fixed in
version 1.0.2-6.

For the unstable distribution (sid) this problem has been fixed in
version 1.0.2-6.

We recommend that you upgrade your bzip2 packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20730-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 730-1 (bzip2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bzip2", ver:"1.0.2-1.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbz2-1.0", ver:"1.0.2-1.woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libbz2-dev", ver:"1.0.2-1.woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
