###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opensc_sec_bypass_vuln.nasl 685 2009-03-10 20:37:34Z mar $
#
# OpenSC Security Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800370);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"2.1");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-0368");
  script_bugtraq_id(33922);
  script_name("OpenSC Security Bypass Vulnerability");
  desc = "

  Overview: This host is installed with OpenSC and is prone to security bypass
  vulnerability.

  Vulnerability Insight:
  Security issue due to OpenSC incorrectly initializing private data objects.
  This can be exploited to access data objects which are intended to be
  private through low level APDU commands or debugging tool.

  Impact:
  Successful exploitation will let the attacker to access data objects
  which are intended to be private.

  Impact Level: Application

  Affected Software/OS:
  OpenSC version prior to 0.11.7 on Linux.

  Fix:
  Upgrade to OpenSC version 0.11.7
  http://www.opensc-project.org/files/opensc

  References:
  http://secunia.com/advisories/34052
  http://xforce.iss.net/xforce/xfdb/48958
  http://www.opensc-project.org/pipermail/opensc-announce/2009-February/000023.html

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:L/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 1.7
  Risk factor: Low";

  script_description(desc);
  script_summary("Check for the version of OpenSC");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_opensc_detect.nasl");
  script_require_keys("OpenSC/Ver");
  exit(0);
}


include("version_func.inc");

openscVer = get_kb_item("OpenSC/Ver");
if(openscVer != NULL)
{
  # Check for the version OpenSC < 0.11.7
  if(version_is_less(version:openscVer, test_version:"0.11.7")){
    security_warning(0);
  }
}
