###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for squid vulnerabilities USN-414-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840151);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "414-1");
  script_cve_id("CVE-2007-0247", "CVE-2007-0248");
  script_name( "Ubuntu Update for squid vulnerabilities USN-414-1");
  desc = "

  Vulnerability Insight:

  David Duncan Ross Palmer and Henrik Nordstrom discovered that squid
  incorrectly handled special characters in FTP URLs.  Remote users with
  access to squid could crash the server leading to a denial of service.
  (CVE-2007-0247)
  
  Erick Dantas Rotole and Henrik Nordstrom discovered that squid could end
  up in an endless loop when exhausted of available external ACL helpers.
  Remote users with access to squid could cause CPU starvation, possibly
  leading to a denial of service.  This does not affect a default Ubuntu
  installation, since external ACL helpers must be configured and used.
  (CVE-2007-0248)

  Affected Software/OS:
  squid vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-January/000473.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of squid vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"squid-cgi", ver:"2.5.12-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid", ver:"2.5.12-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squidclient", ver:"2.5.12-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-common", ver:"2.5.12-4ubuntu2.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"squid-cgi", ver:"2.6.1-3ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid", ver:"2.6.1-3ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squidclient", ver:"2.6.1-3ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"squid-common", ver:"2.6.1-3ubuntu1.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}