#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
##############################################################################
#
#  SMB Registry : Windows Service Pack version
#
#  Date Written: 2008/07/07
#
#  Revision: 1.4
#
#  Log: Modified by SecPod.
#  Issue #03 (By schandan)
#  Modified to support Win2K and Win2003 ServicePack Version.
#
##############################################################################


if(description)
{
 script_id(10401);
 script_cve_id("CAN-1999-0662");
 script_copyright("This script is Copyright (C) 2000 Renaud Deraison");
 script_version("Revision: 1.4 ");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_category(ACT_GATHER_INFO);
 script_family("Windows");
 script_name("SMB Registry : Windows Service Pack version");
 script_summary("Check for Service Pack on the remote host");
 desc = "
 This script reads the registry key to retrieve Windows Service Pack
 Version and sets KnowledgeBase.

 Risk factor : None";
 script_description(desc);
 script_dependencies("smb_registry_access.nasl");
 script_require_keys("SMB/registry_access");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 access = get_kb_item("SMB/registry_access");
 if(!access){
        exit(0);
 }

 winVal = registry_get_sz(key:"SOFTWARE\Microsoft\Windows NT\CurrentVersion",
                         item:"CurrentVersion");

 if(winVal){
        set_kb_item(name:"SMB/WindowsVersion", value:winVal);
 }

 csdVer = registry_get_sz(key:"SOFTWARE\Microsoft\Windows NT\CurrentVersion",
                          item:"CSDVersion");

 if(csdVer)
 {
        set_kb_item(name:"SMB/CSDVersion", value:csdVer);

        csdVer = eregmatch(pattern:"Service Pack [0-9]+", string:csdVer);
        csdVer = csdVer[0];

        if(winVal == "4.0"){
                set_kb_item(name:"SMB/WinNT4/ServicePack", value:csdVer);
        }
        if(winVal == "5.0"){
                set_kb_item(name:"SMB/Win2K/ServicePack", value:csdVer);
        }
        if(winVal == "5.1"){
                set_kb_item(name:"SMB/WinXP/ServicePack", value:csdVer);
        }
        if(winVal == "5.2"){
                set_kb_item(name:"SMB/Win2003/ServicePack", value:csdVer);
        }

        report = string("The remote Windows ", winVal, " is running ", csdVer, "\n");
        security_note(data:report, port:port);
 }
