# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-806-1 (python2.5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64488);
 script_cve_id("CVE-2008-4864", "CVE-2008-5031");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Ubuntu USN-806-1 (python2.5)");

 desc = "The remote host is missing an update to python2.5
announced via advisory USN-806-1.

Details follow:

It was discovered that Python incorrectly handled certain arguments in the
imageop module. If an attacker were able to pass specially crafted
arguments through the crop function, they could execute arbitrary code with
user privileges. For Python 2.5, this issue only affected Ubuntu 8.04 LTS.
(CVE-2008-4864)

Multiple integer overflows were discovered in Python's stringobject and
unicodeobject expandtabs method. If an attacker were able to exploit these
flaws they could execute arbitrary code with user privileges or cause
Python applications to crash, leading to a denial of service.
(CVE-2008-5031)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  python2.4                       2.4.3-0ubuntu6.3
  python2.4-minimal               2.4.3-0ubuntu6.3

Ubuntu 8.04 LTS:
  python2.4                       2.4.5-1ubuntu4.2
  python2.4-minimal               2.4.5-1ubuntu4.2
  python2.5                       2.5.2-2ubuntu6
  python2.5-minimal               2.5.2-2ubuntu6

Ubuntu 8.10:
  python2.4                       2.4.5-5ubuntu1.1
  python2.4-minimal               2.4.5-5ubuntu1.1

After a standard system upgrade you need to reboot your computer to
effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-806-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-806-1 (python2.5)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-doc", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-gdbm", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-minimal", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-tk", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4", ver:"2.4.3-0ubuntu6.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-doc", ver:"2.4.5-1ubuntu4.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.5-1ubuntu4.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5-doc", ver:"2.5.2-2ubuntu6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5-examples", ver:"2.5.2-2ubuntu6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.5-1ubuntu4.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"idle-python2.5", ver:"2.5.2-2ubuntu6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.5-1ubuntu4.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.5-1ubuntu4.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-minimal", ver:"2.4.5-1ubuntu4.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4", ver:"2.4.5-1ubuntu4.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5-dbg", ver:"2.5.2-2ubuntu6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5-dev", ver:"2.5.2-2ubuntu6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5-minimal", ver:"2.5.2-2ubuntu6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.5", ver:"2.5.2-2ubuntu6", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-doc", ver:"2.4.5-5ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-examples", ver:"2.4.5-5ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"idle-python2.4", ver:"2.4.5-5ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dbg", ver:"2.4.5-5ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-dev", ver:"2.4.5-5ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-minimal", ver:"2.4.5-5ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4", ver:"2.4.5-5ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
