# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-817-1 (thunderbird)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64777);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Ubuntu USN-817-1 (thunderbird)");

 desc = "The remote host is missing an update to thunderbird
announced via advisory USN-817-1.

Details follow:

Several flaws were discovered in the rendering engine of Thunderbird. If
Javascript were enabled, an attacker could exploit these flaws to crash
Thunderbird.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  thunderbird                     2.0.0.23+build1+nobinonly-0ubuntu0.8.04.1

Ubuntu 8.10:
  thunderbird                     2.0.0.23+build1+nobinonly-0ubuntu0.8.10.1

Ubuntu 9.04:
  thunderbird                     2.0.0.23+build1+nobinonly-0ubuntu0.9.04.1

After a standard system upgrade you need to restart Thunderbird to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-817-1
http://launchpad.net/bugs/416646

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-817-1 (thunderbird)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.23+build1+nobinonly-0ubuntu0.9.04.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
