/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                             avtImageOptions.C                              //
// ************************************************************************* //

#include <avtImageOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;


// ****************************************************************************
//  Function: GetImageReadOptions
//
//  Purpose:
//      Creates the options for Image readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 11:03:26 PDT 2007
//
// ****************************************************************************

DBOptionsAttributes *
GetImageReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}


// ****************************************************************************
//  Function: GetImageWriteOptions
//
//  Purpose:
//      Creates the options for Image writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 11:03:26 PDT 2007
//
// ****************************************************************************

DBOptionsAttributes *
GetImageWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    //
    // Format options
    //
    rv->SetEnum("Format", 0);
    vector<string> formats;
    formats.push_back("TIFF");  // 0
    formats.push_back("PNG");   // 1
    formats.push_back("JPEG");  // 2
    formats.push_back("BMP");   // 3
    formats.push_back("PNM");   // 4
    rv->SetEnumStrings("Format", formats);

    rv->SetBool("Normalize [0,255]", true);

    rv->SetEnum("TIFF Compression", 0);
    vector<string> compressions;
    compressions.push_back("None");     // 0
    compressions.push_back("PackBits"); // 1
    compressions.push_back("Deflate");  // 2
    rv->SetEnumStrings("TIFF Compression", compressions);

    rv->SetInt("JPEG Quality [0,100]", 100);

    return rv;
}
