/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef USERSSTATISTICSMODEL_H
#define USERSSTATISTICSMODEL_H

#include <QAbstractTableModel>
#include <QVector>

class UsersList;
class UserWgt;
/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class UsersStatisticsModel : public QAbstractTableModel
{
  Q_OBJECT
  public:
    enum ColumnID{NickName, Gender, RealName, Status, StatusDescription, IP, CompName, OS, Uptime, ChatTime, Last, Invalid = 1000};

  private:
    UsersList*            m_users;
    QVector<uint>         m_columns;
    mutable int           m_sortingColumn;
    mutable Qt::SortOrder m_sortOrder;
    mutable UserWgt**     m_usersOrder;
    mutable int           m_usersOrderSize;
    mutable int           m_usersOrderMaxSize;

  private:
    int cmp(UserWgt*, UserWgt*, int, Qt::SortOrder) const;

  public:
    UsersStatisticsModel(QObject* = 0);
    ~UsersStatisticsModel();

    int rowCount(const QModelIndex & = QModelIndex()) const;

    int columnCount(const QModelIndex & = QModelIndex()) const
    {return m_columns.size();}

    QVariant data      (const QModelIndex &index, int role) const;

    QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
    void sort          (int column, Qt::SortOrder order = Qt::AscendingOrder) const;

    void resort() const
    {sort(m_sortingColumn, m_sortOrder);}

    void setUsers(UsersList* u)
    {m_users = u;}

    void resetModel()
    {reset();}

    int columnID(uint n)     {if(n >= (uint)m_columns.size()) return Invalid; else return m_columns[n];}
    int columnsCount() const {return m_columns.size();}
    void clearColumns()      {m_columns.clear();}
    void addColumn(uint c)   {if(c < Last) m_columns.append(c);}

    int sortingColumn() const    {return m_sortingColumn;}
    void setSortingColumn(int c) {m_sortingColumn = c; resort();}

    Qt::SortOrder sortOrder() const    {return m_sortOrder;}
    void setSortOrder(Qt::SortOrder o) {m_sortOrder = o; resort();}
};

#endif
