% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumb.R
\name{plumb_api}
\alias{plumb_api}
\alias{available_apis}
\title{Process a Package's Plumber API}
\usage{
plumb_api(package = NULL, name = NULL, edit = FALSE)

available_apis(package = NULL)
}
\arguments{
\item{package}{Package to inspect}

\item{name}{Name of the package folder to \code{\link[=plumb]{plumb()}}.}

\item{edit}{Whether or not to open the API source code for viewing / editing}
}
\value{
A \code{\link{Plumber}} object. If either \code{package} or \code{name} is null, the appropriate \code{\link[=available_apis]{available_apis()}} will be returned.
}
\description{
So that packages can ship multiple plumber routers, users should store their Plumber APIs
in the \code{inst} subfolder \code{plumber} (\code{./inst/plumber/API_1/plumber.R}).
}
\details{
To view all available Plumber APIs across all packages, please call \code{available_apis()}.
A \code{package} value may be provided to only display a particular package's Plumber APIs.
}
\section{Functions}{
\itemize{
\item \code{plumb_api()}: \code{\link[=plumb]{plumb()}}s a package's Plumber API. Returns a \code{\link{Plumber}} router object

\item \code{available_apis()}: Displays all available package Plumber APIs. Returns a \code{data.frame} of \code{package}, \code{name}, and \code{source_directory} information.

}}
