% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_set.R
\name{pr_set_error}
\alias{pr_set_error}
\title{Set the error handler that is invoked if any filter or endpoint generates an
error}
\usage{
pr_set_error(pr, fun)
}
\arguments{
\item{pr}{A Plumber API. Note: The supplied Plumber API object will also be updated in place as well as returned by the function.}

\item{fun}{An error handler function. This should accept \code{req}, \code{res}, and the error value}
}
\value{
The Plumber router with a modified error handler
}
\description{
Set the error handler that is invoked if any filter or endpoint generates an
error
}
\examples{
\dontrun{
handler_error <- function(req, res, err){
  res$status <- 500
  list(error = "Custom Error Message")
}

pr() \%>\%
  pr_get("/error", function() log("a")) \%>\%
  pr_set_error(handler_error) \%>\%
  pr_run()
}
}
