#! /bin/sh

# Test listing of database tables.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db

sqlite3 ${TMP_DB_FILE} < tests/inputs/samples-r92.sql

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}.db"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=get
export QUERY_STRING="format=csv"
export REMOTE_USER=tester

${INPUT_SCRIPT} format=csv

rm -f ${TMP_DB_FILE}
