/*!
Functions that create IRIs for the OWL 2 Web ontology Language [OWL2](http://www.w3.org/TR/owl2-quick-reference/) namespace.

*/

namespace! {
    "owl",
    "http://www.w3.org/2002/07/owl#",
    {
        thing, "Thing",
        nothing, "Nothing",
        intersection_of, "intersectionOf",
        union_of, "unionOf",
        complement_of, "complementOf",
        one_of, "oneOf",
        restriction, "Restriction",
        on_property, "onProperty",
        on_class, "onClass",
        on_datatype, "onDatatype",
        all_values_from, "allValuesFrom",
        some_values_from, "someValuesFrom",
        has_value, "hasValue",
        has_self, "hasSelf",
        cardinality, "cardinality",
        qualified_cardinality, "qualifiedCardinality",
        max_cardinality, "maxCardinality",
        max_qualified_cardinality, "maxQualifiedCardinality",
        min_cardinality, "minCardinality",
        min_qualified_cardinality, "minQualifiedCardinality",
        datatype_complement_of, "datatypeComplementOf",
        with_restrictions, "withRestrictions",
        equivalent_class, "equivalentClass",
        disjoint_with, "disjointWith",
        all_disjoint_classes, "AllDisjointClasses",
        members, "members",
        disjoint_union_of, "disjointUnionOf",
        property_chain_axiom, "propertyChainAxiom",
        equivalent_property, "equivalentProperty",
        property_disjoint_with, "propertyDisjointWith",
        all_disjoint_properties, "AllDisjointProperties",
        inverse_of, "inverseOf",
        functional_property, "FunctionalProperty",
        inverse_functional_property, "InverseFunctionalProperty",
        reflexive_property, "ReflexiveProperty",
        irreflexive_property, "IrreflexiveProperty",
        symmetric_property, "SymmetricProperty",
        asymmetric_property, "AsymmetricProperty",
        transitive_property, "TransitiveProperty",
        same_as, "sameAs",
        different_from, "differentFrom",
        all_different, "AllDifferent",
        negative_property_assertion, "NegativePropertyAssertion",
        source_individual, "sourceIndividual",
        assertion_property, "assertionProperty",
        target_individual, "targetIndividual",
        target_value, "targetValue",
        has_key, "hasKey",
        class, "Class",
        object_property, "ObjectProperty",
        datatype_property, "DatatypeProperty",
        annotation_property, "AnnotationProperty",
        named_individual, "NamedIndividual",
        axiom, "Axiom",
        annotated_source, "annotatedSource",
        annotated_property, "annotatedProperty",
        annotated_target, "annotatedTarget",
        version_info, "versionInfo",
        deprecated, "deprecated",
        backward_compatible_with, "backwardCompatibleWith",
        incompatible_with, "incompatible_with",
        prior_version, "priorVersion",
        ontology, "Ontology",
        version, "version",
        imports, "imports",
        rational, "rational",
        real, "real",
        distinct_members, "distinctMembers",
        ontology_property, "OntologyProperty",
        deprecated_class, "DeprecatedClass",
        deprecated_property, "DeprecatedProperty"
    }
}
