#### This error code is internal to the compiler and will not be emitted with normal Rust code.

Feature declared with conflicting stability requirements.

```compile_fail,E0711
// NOTE: this attribute is perma-unstable and should *never* be used outside of
//       stdlib and the compiler.
#![feature(staged_api)]

#![stable(feature = "...", since = "1.0.0")]

#[stable(feature = "foo", since = "1.0.0")]
fn foo_stable_1_0_0() {}

// error: feature `foo` is declared stable since 1.29.0
#[stable(feature = "foo", since = "1.29.0")]
fn foo_stable_1_29_0() {}

// error: feature `foo` is declared unstable
#[unstable(feature = "foo", issue = "none")]
fn foo_unstable() {}
```

In the above example, the `foo` feature is first defined to be stable since
1.0.0, but is then re-declared stable since 1.29.0. This discrepancy in
versions causes an error. Furthermore, `foo` is then re-declared as unstable,
again the conflict causes an error.

This error can be fixed by splitting the feature, this allows any
stability requirements and removes any possibility of conflict.
