// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2009 - DIGITEO - Vincent COUVERT
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- Non-regression test for bug 3967 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/3967
//
// <-- Short Description -->
//    when called with a transfer function, pfss returns a set of state-space systems as a result. 
//    pfss used to return a transfer functions when called with a transfer function (verified of 4.1.2).
//    When called with a tf, pfss should of course return a tf. 
//
// <-- CLI SHELL MODE -->

tf = syslin("c", 1/%s);
ss = tf2ss(tf);

if pfss(tf)<>list(tf) then pause;end
if pfss(ss)<>list(ss) then pause;end
