// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Serge Steer
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->
// <-- NO CHECK REF -->

// Maple code used to create reference

// Digits := 40; 
// writeto("cosd.ref"); interface(prettyprint = 0); 
// for i from 0 to 360 do print(-180+i, evalf[30](cos(-Pi+i*Pi/180), 30)) end do; 
// writeto(terminal);
pi = %pi;       //used to make following code runnable under Matlab
eps = %eps;
Inf = %inf;
NaN = %nan;

ref=[-180, -1.
-179, -.999847695156391239157011558814
-178, -.999390827019095730006243440044
-177, -.998629534754573873784492058439
-176, -.997564050259824247613162680644
-175, -.996194698091745532295010402474
-174, -.994521895368273336922691944981
-173, -.992546151641322034980061589331
-172, -.990268068741570315083774867345
-171, -.987688340595137726190040247693
-170, -.984807753012208059366743024590
-169, -.981627183447663953496504899818
-168, -.978147600733805637928566747870
-167, -.974370064785235228539694480088
-166, -.970295726275996472306377874034
-165, -.965925826289068286749743199729
-164, -.961261695938318861916497048557
-163, -.956304755963035481338650816618
-162, -.951056516295153572116439333379
-161, -.945518575599316810348124707519
-160, -.939692620785908384054109277325
-159, -.933580426497201748990043063139
-158, -.927183854566787400806474451137
-157, -.920504853452440327396894723300
-156, -.913545457642600895502127571986
-155, -.906307787036649963242552656754
-154, -.898794046299166992782295676696
-153, -.891006524188367862359709571414
-152, -.882947592858926942032171360315
-151, -.874619707139395800284636958661
-150, -.866025403784438646763723170755
-149, -.857167300702112287465217980145
-148, -.848048096156425970386176178690
-147, -.838670567945424029637590941805
-146, -.829037572555041692006336841501
-145, -.819152044288991789684488385917
-144, -.809016994374947424102293417183
-143, -.798635510047292846284000804068
-142, -.788010753606721956693977787836
-141, -.777145961456970879979937743672
-140, -.766044443118978035202392650556
-139, -.754709580222771997942984219561
-138, -.743144825477394235014697048975
-137, -.731353701619170483287543608275
-136, -.719339800338651139356054674457
-135, -.707106781186547524400844362105
-134, -.694658370458997286656406299422
-133, -.681998360062498500442225784712
-132, -.669130606358858213826273330686
-131, -.656059028990507284782495964024
-130, -.642787609686539326322643409907
-129, -.629320391049837452705902458281
-128, -.615661475325658279668811092843
-127, -.601815023152048279917977000442
-126, -.587785252292473129168705954639
-125, -.573576436351046096108031912825
-124, -.559192903470746830160428139987
-123, -.544639035015027082224083692080
-122, -.529919264233204954046781151819
-121, -.515038074910054210081631936397
-120, -.500000000000000000000000000000
-119, -.484809620246337029075379622414
-118, -.469471562785890775959462288230
-117, -.453990499739546791560408366356
-116, -.438371146789077417452734540661
-115, -.422618261740699436186978489646
-114, -.406736643075800207753985990344
-113, -.390731128489273755062084588887
-112, -.374606593415912035414963774503
-111, -.358367949545300273484137789411
-110, -.342020143325668733044099614684
-109, -.325568154457156668714008935792
-108, -.309016994374947424102293417185
-107, -.292371704722736728097468695374
-106, -.275637355816999185649971574613
-105, -.258819045102520762348898837621
-104, -.241921895599667722560442374102
-103, -.224951054343864998051107208339
-102, -.207911690817759337101742284406
-101, -.190808995376544812405140487954
-100, -.173648177666930348851716626770
-99, -.156434465040230869010105319463
-98, -.139173100960065444112496663302
-97, -.121869343405147481112893919227
-96, -.104528463267653471399834154803
-95, -0.871557427476581735580642708428e-1
-94, -0.697564737441253007759588351943e-1
-93, -0.523359562429438327221186296142e-1
-92, -0.348994967025009716459951816253e-1
-91, -0.174524064372835128194189785212e-1
-90, 0.
-89, 0.174524064372835128194189785212e-1
-88, 0.348994967025009716459951816253e-1
-87, 0.523359562429438327221186296142e-1
-86, 0.697564737441253007759588351943e-1
-85, 0.871557427476581735580642708428e-1
-84, .104528463267653471399834154803
-83, .121869343405147481112893919227
-82, .139173100960065444112496663302
-81, .156434465040230869010105319463
-80, .173648177666930348851716626770
-79, .190808995376544812405140487954
-78, .207911690817759337101742284406
-77, .224951054343864998051107208339
-76, .241921895599667722560442374102
-75, .258819045102520762348898837621
-74, .275637355816999185649971574613
-73, .292371704722736728097468695374
-72, .309016994374947424102293417185
-71, .325568154457156668714008935792
-70, .342020143325668733044099614684
-69, .358367949545300273484137789411
-68, .374606593415912035414963774503
-67, .390731128489273755062084588887
-66, .406736643075800207753985990344
-65, .422618261740699436186978489646
-64, .438371146789077417452734540661
-63, .453990499739546791560408366356
-62, .469471562785890775959462288230
-61, .484809620246337029075379622414
-60, .500000000000000000000000000000
-59, .515038074910054210081631936397
-58, .529919264233204954046781151819
-57, .544639035015027082224083692080
-56, .559192903470746830160428139987
-55, .573576436351046096108031912825
-54, .587785252292473129168705954639
-53, .601815023152048279917977000442
-52, .615661475325658279668811092843
-51, .629320391049837452705902458281
-50, .642787609686539326322643409907
-49, .656059028990507284782495964024
-48, .669130606358858213826273330686
-47, .681998360062498500442225784712
-46, .694658370458997286656406299422
-45, .707106781186547524400844362105
-44, .719339800338651139356054674457
-43, .731353701619170483287543608275
-42, .743144825477394235014697048975
-41, .754709580222771997942984219561
-40, .766044443118978035202392650556
-39, .777145961456970879979937743671
-38, .788010753606721956693977787836
-37, .798635510047292846284000804068
-36, .809016994374947424102293417183
-35, .819152044288991789684488385917
-34, .829037572555041692006336841501
-33, .838670567945424029637590941805
-32, .848048096156425970386176178690
-31, .857167300702112287465217980145
-30, .866025403784438646763723170755
-29, .874619707139395800284636958661
-28, .882947592858926942032171360315
-27, .891006524188367862359709571414
-26, .898794046299166992782295676696
-25, .906307787036649963242552656754
-24, .913545457642600895502127571986
-23, .920504853452440327396894723300
-22, .927183854566787400806474451137
-21, .933580426497201748990043063139
-20, .939692620785908384054109277325
-19, .945518575599316810348124707519
-18, .951056516295153572116439333379
-17, .956304755963035481338650816618
-16, .961261695938318861916497048557
-15, .965925826289068286749743199729
-14, .970295726275996472306377874034
-13, .974370064785235228539694480088
-12, .978147600733805637928566747870
-11, .981627183447663953496504899818
-10, .984807753012208059366743024589
-9, .987688340595137726190040247693
-8, .990268068741570315083774867345
-7, .992546151641322034980061589331
-6, .994521895368273336922691944981
-5, .996194698091745532295010402474
-4, .997564050259824247613162680644
-3, .998629534754573873784492058439
-2, .999390827019095730006243440044
-1, .999847695156391239157011558814
0, 1.
1, .999847695156391239157011558814
2, .999390827019095730006243440044
3, .998629534754573873784492058439
4, .997564050259824247613162680644
5, .996194698091745532295010402474
6, .994521895368273336922691944981
7, .992546151641322034980061589331
8, .990268068741570315083774867345
9, .987688340595137726190040247693
10, .984807753012208059366743024589
11, .981627183447663953496504899818
12, .978147600733805637928566747870
13, .974370064785235228539694480088
14, .970295726275996472306377874034
15, .965925826289068286749743199729
16, .961261695938318861916497048557
17, .956304755963035481338650816618
18, .951056516295153572116439333379
19, .945518575599316810348124707519
20, .939692620785908384054109277325
21, .933580426497201748990043063139
22, .927183854566787400806474451137
23, .920504853452440327396894723300
24, .913545457642600895502127571986
25, .906307787036649963242552656754
26, .898794046299166992782295676696
27, .891006524188367862359709571414
28, .882947592858926942032171360315
29, .874619707139395800284636958661
30, .866025403784438646763723170755
31, .857167300702112287465217980145
32, .848048096156425970386176178690
33, .838670567945424029637590941805
34, .829037572555041692006336841501
35, .819152044288991789684488385917
36, .809016994374947424102293417183
37, .798635510047292846284000804068
38, .788010753606721956693977787836
39, .777145961456970879979937743671
40, .766044443118978035202392650556
41, .754709580222771997942984219561
42, .743144825477394235014697048975
43, .731353701619170483287543608275
44, .719339800338651139356054674457
45, .707106781186547524400844362105
46, .694658370458997286656406299422
47, .681998360062498500442225784712
48, .669130606358858213826273330686
49, .656059028990507284782495964024
50, .642787609686539326322643409907
51, .629320391049837452705902458281
52, .615661475325658279668811092843
53, .601815023152048279917977000442
54, .587785252292473129168705954639
55, .573576436351046096108031912825
56, .559192903470746830160428139987
57, .544639035015027082224083692080
58, .529919264233204954046781151819
59, .515038074910054210081631936397
60, .500000000000000000000000000000
61, .484809620246337029075379622414
62, .469471562785890775959462288230
63, .453990499739546791560408366356
64, .438371146789077417452734540661
65, .422618261740699436186978489646
66, .406736643075800207753985990344
67, .390731128489273755062084588887
68, .374606593415912035414963774503
69, .358367949545300273484137789411
70, .342020143325668733044099614684
71, .325568154457156668714008935792
72, .309016994374947424102293417185
73, .292371704722736728097468695374
74, .275637355816999185649971574613
75, .258819045102520762348898837621
76, .241921895599667722560442374102
77, .224951054343864998051107208339
78, .207911690817759337101742284406
79, .190808995376544812405140487954
80, .173648177666930348851716626770
81, .156434465040230869010105319463
82, .139173100960065444112496663302
83, .121869343405147481112893919227
84, .104528463267653471399834154803
85, 0.871557427476581735580642708428e-1
86, 0.697564737441253007759588351943e-1
87, 0.523359562429438327221186296142e-1
88, 0.348994967025009716459951816253e-1
89, 0.174524064372835128194189785212e-1
90, 0.
91, -0.174524064372835128194189785212e-1
92, -0.348994967025009716459951816253e-1
93, -0.523359562429438327221186296142e-1
94, -0.697564737441253007759588351943e-1
95, -0.871557427476581735580642708428e-1
96, -.104528463267653471399834154803
97, -.121869343405147481112893919227
98, -.139173100960065444112496663302
99, -.156434465040230869010105319463
100, -.173648177666930348851716626770
101, -.190808995376544812405140487954
102, -.207911690817759337101742284406
103, -.224951054343864998051107208339
104, -.241921895599667722560442374102
105, -.258819045102520762348898837621
106, -.275637355816999185649971574613
107, -.292371704722736728097468695374
108, -.309016994374947424102293417185
109, -.325568154457156668714008935792
110, -.342020143325668733044099614684
111, -.358367949545300273484137789411
112, -.374606593415912035414963774503
113, -.390731128489273755062084588887
114, -.406736643075800207753985990344
115, -.422618261740699436186978489646
116, -.438371146789077417452734540661
117, -.453990499739546791560408366356
118, -.469471562785890775959462288230
119, -.484809620246337029075379622414
120, -.500000000000000000000000000000
121, -.515038074910054210081631936397
122, -.529919264233204954046781151819
123, -.544639035015027082224083692080
124, -.559192903470746830160428139987
125, -.573576436351046096108031912825
126, -.587785252292473129168705954639
127, -.601815023152048279917977000442
128, -.615661475325658279668811092843
129, -.629320391049837452705902458281
130, -.642787609686539326322643409907
131, -.656059028990507284782495964024
132, -.669130606358858213826273330686
133, -.681998360062498500442225784712
134, -.694658370458997286656406299422
135, -.707106781186547524400844362105
136, -.719339800338651139356054674457
137, -.731353701619170483287543608275
138, -.743144825477394235014697048975
139, -.754709580222771997942984219561
140, -.766044443118978035202392650556
141, -.777145961456970879979937743671
142, -.788010753606721956693977787836
143, -.798635510047292846284000804068
144, -.809016994374947424102293417183
145, -.819152044288991789684488385917
146, -.829037572555041692006336841501
147, -.838670567945424029637590941805
148, -.848048096156425970386176178690
149, -.857167300702112287465217980145
150, -.866025403784438646763723170755
151, -.874619707139395800284636958661
152, -.882947592858926942032171360315
153, -.891006524188367862359709571414
154, -.898794046299166992782295676696
155, -.906307787036649963242552656754
156, -.913545457642600895502127571986
157, -.920504853452440327396894723300
158, -.927183854566787400806474451137
159, -.933580426497201748990043063139
160, -.939692620785908384054109277325
161, -.945518575599316810348124707519
162, -.951056516295153572116439333379
163, -.956304755963035481338650816618
164, -.961261695938318861916497048557
165, -.965925826289068286749743199729
166, -.970295726275996472306377874034
167, -.974370064785235228539694480088
168, -.978147600733805637928566747870
169, -.981627183447663953496504899818
170, -.984807753012208059366743024589
171, -.987688340595137726190040247693
172, -.990268068741570315083774867345
173, -.992546151641322034980061589331
174, -.994521895368273336922691944981
175, -.996194698091745532295010402474
176, -.997564050259824247613162680644
177, -.998629534754573873784492058439
178, -.999390827019095730006243440044
179, -.999847695156391239157011558814
180, -1.
];

x=ref(:,1);e=max(abs((ref(:,2)-cosd(x))));
if e>eps then pause,end
x=ref(:,1)+2^6*360; e=max(abs((ref(:,2)-cosd(x))));
if e>eps then pause,end

x=ref(:,1)+2^10*360; e=max(abs((ref(:,2)-cosd(x))));
if e>eps then pause,end

if ~isnan(cosd(-Inf)) then pause,end
if ~isnan(cosd(Inf)) then pause,end
if ~isnan(cosd(NaN)) then pause,end

assert_checkequal(1./cosd([-90 90]), [%inf %inf]);

if cosd([])<>[] then pause,end

