// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Serge Steer
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// Maple code used to create reference

//Digits := 40; 
//writeto("sec.ref"); interface(prettyprint = 0); 
//for i from 0 to 80 do print(-4+(i/10), evalf[30](sec(-4+(i/10)), 30)) end do; 
//writeto(terminal);
ieee(2);
pi=%pi;eps=%eps;Inf=%inf;NaN=%nan; //used to make following code runnable under Matlab

ref=[-4, -1.52988565646639757462951092294
     -39/10, -1.37753891680277005963861004901
     -19/5, -1.26427410997555454000707635103
     -37/10, -1.17910619338528634022113736807
     -18/5, -1.11512753243832782035714527102
     -7/2, -1.06785504719181065881330425175
     -17/5, -1.03434202471143959405129218882
     -33/10, -1.01267897375992889029877035847
     -16/5, -1.00170813696173995122730343283
     -31/10, -1.00086559833920764899225073711
     -3, -1.01010866590799375130303648146
     -29/10, -1.02991049037209049306197816095
     -14/5, -1.06132062129872585494006839255
     -27/10, -1.10610641952633969634254886061
     -13/5, -1.16701263269986450313277852533
     -5/2, -1.24821565146881783090643327407
     -12/5, -1.35612764107435065048442884421
     -23/10, -1.50087946746025490500214773490
     -11/5, -1.69923211813735329043944350049
     -21/10, -1.98080165596722395719422258125
     -2, -2.40299796172238098975460040142
     -19/10, -3.09320220167269274955569301386
     -9/5, -4.40136787185363222194399552336
     -17/10, -7.76129399605035542850515196616
     -8/5, -34.2471356100186892052954614833
     -3/2, 14.1368329029699030819232284342
     -7/5, 5.88349008482734482699427030984
     -13/10, 3.73833412707544117194366839641
     -6/5, 2.75970360133240645688343293924
     -11/10, 2.20460438871735903398602533306
     -1, 1.85081571768092561791175324140
     -9/10, 1.60872581046604951302401286231
     -4/5, 1.43532419967223980049695240816
     -7/10, 1.30745925973359386987467283531
     -3/5, 1.21162831451231670461455512137
     -1/2, 1.13949392732454912231332776820
     -2/5, 1.08570442838323870311392995516
     -3/10, 1.04675160153808560093279084559
     -1/5, 1.02033884494119268979243277685
     -1/10, 1.00502091840045542846511410131
     0, 1.
     1/10, 1.00502091840045542846511410131
     1/5, 1.02033884494119268979243277685
     3/10, 1.04675160153808560093279084559
     2/5, 1.08570442838323870311392995516
     1/2, 1.13949392732454912231332776820
     3/5, 1.21162831451231670461455512137
     7/10, 1.30745925973359386987467283531
     4/5, 1.43532419967223980049695240816
     9/10, 1.60872581046604951302401286231
     1, 1.85081571768092561791175324140
     11/10, 2.20460438871735903398602533306
     6/5, 2.75970360133240645688343293924
     13/10, 3.73833412707544117194366839641
     7/5, 5.88349008482734482699427030984
     3/2, 14.1368329029699030819232284342
     8/5, -34.2471356100186892052954614833
     17/10, -7.76129399605035542850515196616
     9/5, -4.40136787185363222194399552336
     19/10, -3.09320220167269274955569301386
     2, -2.40299796172238098975460040142
     21/10, -1.98080165596722395719422258125
     11/5, -1.69923211813735329043944350049
     23/10, -1.50087946746025490500214773490
     12/5, -1.35612764107435065048442884421
     5/2, -1.24821565146881783090643327407
     13/5, -1.16701263269986450313277852533
     27/10, -1.10610641952633969634254886061
     14/5, -1.06132062129872585494006839255
     29/10, -1.02991049037209049306197816095
     3, -1.01010866590799375130303648146
     31/10, -1.00086559833920764899225073711
     16/5, -1.00170813696173995122730343283
     33/10, -1.01267897375992889029877035847
     17/5, -1.03434202471143959405129218882
     7/2, -1.06785504719181065881330425175
     18/5, -1.11512753243832782035714527102
     37/10, -1.17910619338528634022113736807
     19/5, -1.26427410997555454000707635103
     39/10, -1.37753891680277005963861004901
     4, -1.52988565646639757462951092294];

ref=[ref;
     0       1
     pi/3    2
     2*pi/3 -2
     pi/4    sqrt(2)
     3*pi/4 -sqrt(2)
     pi/6    2/sqrt(3)
     5*pi/6 -2/sqrt(3)
     pi     -1];

     
     x=ref(:,1);e=max(abs((ref(:,2)-sec(x))./ref(:,2)));
     if e>15*eps then pause,end
     x=ref(:,1)+2^15*pi; e=max(abs((ref(:,2)-sec(x))./ref(:,2)));
     if e>1d-9 then pause,end
     

     if sec(pi/2)<1d16 then pause,end
     
     if ~isnan(sec(-Inf)) then pause,end
     if ~isnan(sec(Inf)) then pause,end
     if ~isnan(sec(NaN)) then pause,end

     if sec([])<>[] then pause,end

