// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Vladislav TRUBKIN
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
// <-- TEST WITH GRAPHIC -->
// <-- Non-regression test for bug 13441 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/13441
//
// <-- Short Description -->
// Scilab crashes when giving a string for border property of the uicontrol
//
f = figure("figure_name", "FIGURE", ...
"dockable", "off", ...
"axes_size", [300,300], ...
"infobar_visible", "off", ...
"toolbar", "none", ...
"menubar_visible", "off", ...
"menubar", "none", ...
"default_axes", "off", ...
"layout", "border");

mainFrame = uicontrol(f, ...
"style", "frame", ...
"layout", "border");

font = createBorderFont("Serif", 12, "bold");
constraint = createConstraints("border", "left", [150,300]);
leftFrame = uicontrol(mainFrame, ...
"style", "frame", ...
"layout", "gridbag", ...
"constraints", constraint, ...
"tag", "leftFrame");

border = createBorder("titled", createBorder("etched"), "Frame title", "left", "top", font, "blue");
constraint = createConstraints("gridbag", [1 1 1 1], [1 0.1], "both", "left");

// OK test
// mlist
assert_checkequal(execstr("h = uicontrol(leftFrame," +...
"""style"", ""frame""," +...
"""border"", border," +...
"""layout"", ""gridbag""," +...
"""constraints"", constraint);", "errcatch"), 0);
assert_checkequal(execstr("h = uicontrol(leftFrame," +...
"""style"", ""frame""," +...
"""border"", border," +...
"""layout"", ""grid""," +...
"""constraints"", constraint);", "errcatch"), 0);
// []
assert_checkequal(execstr("h = uicontrol(leftFrame," +...
"""style"", ""frame""," +...
"""border"", []," +...
"""layout"", ""grid""," +...
"""constraints"", constraint);", "errcatch"), 0);

// KO test
tmp = gettext("Wrong type for "'%s"' property: An empty matrix or a tlist expected.\n");
errmsgFromSetBorder = msprintf(tmp, "border");
tmp =  gettext("%s: Could not set property "'%s"'.\n");
errmsgFromUicontrol = msprintf(tmp, "uicontrol", "border");

checkValues = list("border", [1, 2, 3, 4], [1 ,2; 1, 2], ...
[1:10], [1:10]', list(), ...
list(1, 2, 3), ...
mlist(["MLIST", "Name", "Value"], ["one","two", "three"], [1, 2, 3]));
action = "h = uicontrol(leftFrame," +...
        """style"", ""frame""," +...
        """border"", checkValues(i)," +...
        """layout"", ""gridbag""," +...
        """constraints"", constraint);";
for i = 1:8
    if i < 6 then
        assert_checkerror(action, errmsgFromSetBorder);
    else
        assert_checkerror(action, errmsgFromUicontrol);
    end
end
