// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - DIGITEO - Pierre MARECHAL
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// <-- Non-regression test for bug 5629 and 5630 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/5629
// https://gitlab.com/scilab/scilab/-/issues/5630
//
// <-- Short Description -->
// 5629: hdf5_save overwrites an empty directory without warning
// 5630: hdf5_save on an existing directory with file in it mess with the permissions.

commonName = pathconvert(TMPDIR+"/bug_5629",%F);
myvar      = 1;

mkdir(commonName);
if ~isdir(commonName) then pause,end
if ~execstr("save(commonName,""myvar"")","errcatch") then pause, end
if ~isdir(commonName) then pause,end
if isfile(commonName) then pause,end
