#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from xpdeint.Stochastic.Generators.Generator import Generator
from xpdeint.CallOnceGuards import callOnceGuard
import random

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1389652445.791002
__CHEETAH_genTimestamp__ = 'Tue Jan 14 09:34:05 2014'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.0/admin/staging/xmds-2.2.0/xpdeint/Stochastic/Generators/DSFMTGenerator.tmpl'
__CHEETAH_srcLastModified__ = 'Wed Aug 28 15:52:21 2013'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class DSFMTGenerator(Generator):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(DSFMTGenerator, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: Generic dSFMT noise at line 29, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''Generic dSFMT noise''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def generatorType(self, **KWS):



        ## Generated from @def generatorType: dsfmt_t* at line 30, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''dsfmt_t*''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def globals(self, **KWS):



        ## CHEETAH: generated from @def globals at line 31, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(DSFMTGenerator, self).globals()
        if _v is not None: write(_filter(_v))
        # 
        _v = VFFSL(SL,"generatorType",True) # u'$generatorType' on line 35, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'$generatorType')) # from line 35, col 1.
        write(u''' ''')
        _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 35, col 16
        if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 35, col 16.
        write(u''';
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    @callOnceGuard
    def static_includes(self, **KWS):



        ## CHEETAH: generated from @def static_includes at line 44, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(DSFMTGenerator, self).static_includes()
        if _v is not None: write(_filter(_v))
        # 
        write(u'''#define DSFMT_DO_NOT_USE_OLD_NAMES
#if CFG_HAVE_SSE2
  #define HAVE_SSE2
#elif CFG_HAVE_ALTIVEC
  #define HAVE_ALTIVEC
#endif

#define DSFMT_MEXP 19937

#include <dSFMT/dSFMT.h>
#include <dSFMT/dSFMT.c>
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    @callOnceGuard
    def static_globals(self, **KWS):



        ## CHEETAH: generated from @def static_globals at line 63, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        if VFFSL(SL,"precision",True) == 'single': # generated from line 64, col 3
            write(u'''// ********************************************************
//   Struct and typedef to help convert a double to two floats
union float_double {
       uint64_t u;
       uint32_t u32[2];
       double d;
       float f[2];
};

typedef union float_double float_double_t;
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    @callOnceGuard
    def static_defines(self, **KWS):



        ## CHEETAH: generated from @def static_defines at line 79, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        if VFFSL(SL,"precision",True) == 'single': # generated from line 80, col 3
            write(u'''// defines to help convert a double to two floats
#define LOWER_FLOAT_MASK   0x00000000007fffffULL
#define UPPER_FLOAT_MASK   0x007fffff00000000ULL
#define UPPER_FLOAT_LSHIFT 3
#define EXPONENT_BITS      0x3f8000003f800000ULL
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    @callOnceGuard
    def static_functionPrototypes(self, **KWS):



        ## CHEETAH: generated from @def static_functionPrototypes at line 90, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        if VFFSL(SL,"precision",True) == 'single': # generated from line 91, col 3
            write(u'''float generate_float_close1_open2_via_dsfmt(dsfmt_t *dsfmt_array);
void generate_float_pair_close1_open2_via_dsfmt(dsfmt_t *dsfmt_array, float &f1, float &f2);
void generate_float_array_close0_open1(dsfmt_t *noise, real array[], int vector_size);
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    @callOnceGuard
    def static_functionImplementations(self, **KWS):



        ## CHEETAH: generated from @def static_functionImplementations at line 99, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        if VFFSL(SL,"precision",True) == 'single': # generated from line 100, col 3
            noiseVector = VFFSL(SL,"parent.parent",True)
            write(u'''// Converts a double in the range [1,2) into two floats in the range [1,2)
// returns one and stores the other in reserve for the next call to this
// function.
float generate_float_close1_open2_via_dsfmt(dsfmt_t *dsfmt_array) 
{
  static float_double_t twiddle;
  static bool bSpareNoise = false;

  if (bSpareNoise) {
    bSpareNoise = false;
    return twiddle.f[1];
  }
  
  twiddle.d = dsfmt_genrand_close1_open2(dsfmt_array);
  twiddle.u = ((twiddle.u << UPPER_FLOAT_LSHIFT) & UPPER_FLOAT_MASK) | (twiddle.u & LOWER_FLOAT_MASK) | EXPONENT_BITS;
  bSpareNoise = true;
  return twiddle.f[0];
}

// Returns two random floats [1,2) by generating one double and converting it 
void generate_float_pair_close1_open2_via_dsfmt(dsfmt_t *noise, float &f1, float &f2) 
{
  float_double_t twiddle;

  twiddle.d = dsfmt_genrand_close1_open2(noise);
  twiddle.u = ((twiddle.u << UPPER_FLOAT_LSHIFT) & UPPER_FLOAT_MASK) | (twiddle.u & LOWER_FLOAT_MASK) | EXPONENT_BITS;
  f1 = twiddle.f[0];
  f2 = twiddle.f[1];
}

/* Fills an array with random floats [0,1) by calling dsfmt_fill_array_close1_open2
** to fill an array half as long with doubles [1,2), then converting these to twice 
** as many floats [1,2), then subtracting one.
** This seems to be slightly faster than calling generate_float_pair_close1_open2_via_dsfmt
** over and over again.
*/
void generate_float_array_close0_open1(dsfmt_t *noise, real noiseVector[], int vector_size) {
  // We can only ask dsfmt to fill arrays that have an even number of doubles, and the
  // number of floats must therefore be divisible by four
  int padding = vector_size & 0x3;
  int num_doubles = (vector_size - padding)/2;
  float_double_t twiddle;

  if (num_doubles > dsfmt_get_min_array_size()) {
    double *array_double = new double[num_doubles];
    dsfmt_fill_array_close1_open2(noise, array_double, num_doubles);

    for (int i=0; i<num_doubles; i++) {
      twiddle.d = array_double[i];
      twiddle.u = ((twiddle.u << UPPER_FLOAT_LSHIFT) & UPPER_FLOAT_MASK) | (twiddle.u & LOWER_FLOAT_MASK) | EXPONENT_BITS;
      reinterpret_cast<real*>(_active_''')
            _v = VFFSL(SL,"noiseVector.id",True) # u'${noiseVector.id}' on line 152, col 39
            if _v is not None: write(_filter(_v, rawExpr=u'${noiseVector.id}')) # from line 152, col 39.
            write(u''')[2*i] = twiddle.f[0] - 1.0f;
      reinterpret_cast<real*>(_active_''')
            _v = VFFSL(SL,"noiseVector.id",True) # u'${noiseVector.id}' on line 153, col 39
            if _v is not None: write(_filter(_v, rawExpr=u'${noiseVector.id}')) # from line 153, col 39.
            write(u''')[2*i+1] = twiddle.f[1] - 1.0f;
    }
    
    // Finish up by generating the 0,1,2 or 3 numbers on the end of the noise vector
    for (int i=0; i<padding; i++)
    {
      reinterpret_cast<real*>(_active_''')
            _v = VFFSL(SL,"noiseVector.id",True) # u'${noiseVector.id}' on line 159, col 39
            if _v is not None: write(_filter(_v, rawExpr=u'${noiseVector.id}')) # from line 159, col 39.
            write(u''')[vector_size-i] = generate_float_close1_open2_via_dsfmt(''')
            _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 159, col 113
            if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 159, col 113.
            write(u''') - 1.0f;
    }
    delete [] array_double;
  }
  else {
    // The number of floats we need does meet the minimum of what dsfmt can provide in 
    // and array, so it by a single number at a time instead.
    for (long _i0 = 0; _i0 < vector_size; _i0++) {
      reinterpret_cast<real*>(_active_''')
            _v = VFFSL(SL,"noiseVector.id",True) # u'${noiseVector.id}' on line 167, col 39
            if _v is not None: write(_filter(_v, rawExpr=u'${noiseVector.id}')) # from line 167, col 39.
            write(u''')[_i0] = generate_float_close1_open2_via_dsfmt(''')
            _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 167, col 103
            if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 167, col 103.
            write(u''') - 1.0f;
    }
  }
}
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def constructArrayUniformRandomNumbers(self, **KWS):



        ## CHEETAH: generated from @def constructArrayUniformRandomNumbers at line 175, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        noiseVector = VFFSL(SL,"parent.parent",True)
        if VFFSL(SL,"precision",True) == 'single': # generated from line 177, col 3
            write(u'''generate_float_array_close0_open1(''')
            _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 178, col 35
            if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 178, col 35.
            write(u''', reinterpret_cast<real*>(_active_''')
            _v = VFFSL(SL,"noiseVector.id",True) # u'${noiseVector.id}' on line 178, col 85
            if _v is not None: write(_filter(_v, rawExpr=u'${noiseVector.id}')) # from line 178, col 85.
            write(u'''), _vector_size);
''')
        else: # generated from line 179, col 3
            write(u'''if (!(_vector_size & 0x1) && _vector_size > dsfmt_get_min_array_size())
  dsfmt_fill_array_open_open(''')
            _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 181, col 30
            if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 181, col 30.
            write(u''', reinterpret_cast<real*>(_active_''')
            _v = VFFSL(SL,"noiseVector.id",True) # u'${noiseVector.id}' on line 181, col 80
            if _v is not None: write(_filter(_v, rawExpr=u'${noiseVector.id}')) # from line 181, col 80.
            write(u'''), _vector_size);
else {
  for (long _i0 = 0; _i0 < _vector_size; _i0++) {
    reinterpret_cast<real*>(_active_''')
            _v = VFFSL(SL,"noiseVector.id",True) # u'${noiseVector.id}' on line 184, col 37
            if _v is not None: write(_filter(_v, rawExpr=u'${noiseVector.id}')) # from line 184, col 37.
            write(u''')[_i0] = dsfmt_genrand_open_open(''')
            _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 184, col 87
            if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 184, col 87.
            write(u''');
  }
}
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def minusOneToOneRandomNumber(self, **KWS):



        ## CHEETAH: generated from @def minusOneToOneRandomNumber at line 190, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        if VFFSL(SL,"precision",True) == 'single': # generated from line 191, col 3
            write(u'''(2.0*generate_float_close1_open2_via_dsfmt(''')
            _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 192, col 44
            if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 192, col 44.
            write(u''') - 3.0)''')
        else: # generated from line 193, col 3
            write(u'''(2.0*dsfmt_genrand_close1_open2(''')
            _v = VFFSL(SL,"generatorName",True) # u'$generatorName' on line 194, col 33
            if _v is not None: write(_filter(_v, rawExpr=u'$generatorName')) # from line 194, col 33.
            write(u''') - 3.0)''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def zeroToOneRandomNumber(self, **KWS):



        ## CHEETAH: generated from @def zeroToOneRandomNumber at line 198, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        if VFFSL(SL,"precision",True) == 'single': # generated from line 199, col 3
            write(u'''(generate_float_close1_open2_via_dsfmt(''')
            _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 200, col 40
            if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 200, col 40.
            write(u''') - 1.0)''')
        else: # generated from line 201, col 3
            write(u'''dsfmt_genrand_open_open(''')
            _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 202, col 25
            if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 202, col 25.
            write(u''')''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def initialiseLocalSeeds(self, **KWS):



        ## CHEETAH: generated from @def initialiseLocalSeeds at line 206, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(DSFMTGenerator, self).initialiseLocalSeeds()
        if _v is not None: write(_filter(_v))
        # 
        _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 210, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 210, col 1.
        write(u''' = (dsfmt_t *)xmds_malloc(sizeof(dsfmt_t));
dsfmt_init_by_array(''')
        _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 211, col 21
        if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 211, col 21.
        write(u''', ''')
        _v = VFFSL(SL,"generatorName",True) # u'${generatorName}' on line 211, col 39
        if _v is not None: write(_filter(_v, rawExpr=u'${generatorName}')) # from line 211, col 39.
        write(u'''_local_seeds, ''')
        _v = VFFSL(SL,"seedCount",True) # u'${seedCount}' on line 211, col 69
        if _v is not None: write(_filter(_v, rawExpr=u'${seedCount}')) # from line 211, col 69.
        write(u''');
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        # DSFMTGenerator.tmpl
        # 
        # Created by Joe Hope on 2009-08-22.
        # 
        # Copyright (c) 2009-2012, Joe Hope
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write(u'''



''')
        # 
        #   Static includes
        #   The callOnceGuard won't work until the same includes are gone from the stochastic feature.
        write(u'''










''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    uselib = ['dsfmt']

    _mainCheetahMethod_for_DSFMTGenerator= 'writeBody'

## END CLASS DEFINITION

if not hasattr(DSFMTGenerator, '_initCheetahAttributes'):
    templateAPIClass = getattr(DSFMTGenerator, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(DSFMTGenerator)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=DSFMTGenerator()).run()


