// ----------------------------------------------------------------------------
//
//  Copyright (C) 2013-2014 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#include <unistd.h>
#include <stdio.h>
#include "nettx.h"
#include "zsockets.h"


Nettx::Nettx (void) :
    _evcnt (0),
    _stop (false)
{
    pthread_mutex_init (&_mutex, 0);
    pthread_cond_init (&_cond, 0);
}


Nettx::~Nettx (void)
{
    pthread_cond_destroy (&_cond);
    pthread_mutex_destroy (&_mutex);
}


void Nettx::start (Lfq_netdata    *packq, 
		   Netdata        *descpack,
 	           int             sockfd,
		   int             rtprio)
{
    _packq = packq;
    _descpack = descpack;
    _sockfd = sockfd;
    thr_start (SCHED_FIFO, rtprio, 0);
}


void Nettx::trigger (void)
{
    pthread_mutex_lock (&_mutex);
    _evcnt++;
    if (_evcnt == 1) pthread_cond_signal (&_cond);
    pthread_mutex_unlock (&_mutex);
}


void Nettx::thr_main (void)
{
    Netdata  *D;

    while (true)
    {
        pthread_mutex_lock (&_mutex);
	while (!_evcnt) pthread_cond_wait (&_cond, &_mutex);
	_evcnt--;
        pthread_mutex_unlock (&_mutex);

	if (_stop)
	{
	    _descpack->set_flags (Netdata::FL_TERM);
            if (send (_sockfd, (char *) _descpack->data (), _descpack->dlen (), 0) < 0) perror ("send");
            close (_sockfd);
 	    return;
	}
        if (_packq->rd_avail () > 0)
	{
	    D = _packq->rd_datap ();
	    send (_sockfd, (char *) D->data (), D->dlen (), 0);
	    _packq->rd_commit ();
	}
	else
	{
            send (_sockfd, (char *) _descpack->data (), _descpack->dlen (), 0);
	}
    }
}
